# Advocacy Ambassador program

Node.js aims to support and encourage developers and developer
advocates to promote Node.js as a project and to help communicate
key messages to their constituencies.

The ambassador program does that by:

* Maintaining an up-to-date set of messages that the Node.js maintainers would like ambassadors
  to promote. These will be documented in the nodejs/ambassadors repository.
* Maintaining an up-to-date set of topics on which additional content
  would benefit the community. These will be documented in the
  nodejs/ambassadors repository.
* Providing a space for collaborators to share new topics/features they
  are working on when they would be happy for ambassadors to help share and get
  early feedback.
* Helping ambassadors promote content that aligns with the
  messages and topics defined.
* Advocating for ambassadors to be part of the OpenJS speakers bureau, even if the
  ambassador is not otherwise an active member of the project itself.
* Each ambassador could add a maximum of three links to resources to learn Node.js
  on a dedicated page on the main Node.js website. At least one of those must be a
  free resource. The Node.js TSC members could ask for coupon codes to verify the
  material if they so decide.

## Ambassadors nominations

Any member of the Node.js organization may nominate an ambassador.
The Technical Steering Committee (TSC) will review/approve ambassadors.

In the initial phase of the program:

* There will be a maximum of 4 ambassadors.
* The term will be for the calendar year. After a year, ambassadors automatically
  drop out of the ambassador list and must be re-nominated.
* Ambassadors will be documented on the nodejs/ambassadors `README.md`.

The TSC may remove an ambassador for any reason,
including promoting content misaligned with the project.

Members of the Node.js organization can nominate ambassadors by opening
a discussion issue with the nomination in
[nodejs/collaborators](https://github.com/nodejs/collaborators/)
titled `Nomination X to be an Ambassador`, where X is the name of the person
being nominated.
If there is no objection within 14 days, the nomination is approved.

## Onboarding

To onboard an ambassador, a member of the TSC will:

* \[ ] Add the ambassador to the nodejs/ambassadors team.
* \[ ] Add the ambassador to the nodejs/ambassadors `README.md`.
* \[ ] Add the ambassador to the OpenJS Slack channel.

## Reviewing content

Ambassadors are asked to share links to new content before asking
for the content to be promoted. The goal is to provide the opportunity
for collaborators to help improve content as opposed to a detailed
nitpick review.

This is done by opening an issue in the nodejs/ambassadors
repository, which limits access to members of the Node.js
organization. The issue may include the link to existing published
content or a draft of the content itself.

Interested members of the Node.js organization may comment
in the issue and the ambassadors are expected to
consider those suggestions and update the content when they feel it
is appropriate.

Explicit approval is not required in the issue (i.e. if there is no
input, that's OK), but review comments should be addressed before
requesting promotion.

## Expectations on Ambassadors

Ambassadors are expected to engage both within the project and externally
in a manner that is consistent with the project's
[Code of Conduct](https://github.com/nodejs/admin/blob/main/CODE_OF_CONDUCT.md)
as well as the additional expectations outlined in
[Member Expectations](https://github.com/nodejs/admin/blob/main/MemberExpectations.md).

## Promoting content

We trust ambassadors to only request promotion of content that lines
up with the messages and topics outlined, that this content does not overly
market their employer or product/business, and that they have followed the review
process. An ambassador can request promotion of content in the following ways:

* Requesting that a post be reposted by the Node.js account on a social media platform.
* @-mentioning the nodejs/ambassadors team to ask other ambassadors to repost.
* Posting a link to the content in the "what's new" issue in nodejs/ambassadors
  so that it goes out on the news feed.

For accounts managed by foundation staff, the staff will repost the social
media post without any need for validation based on the request coming from
an ambassador. For accounts managed by the project with an approval process,
(for example bluesky) documentation for the approval process will indicate
that repost requests from ambassadors should generally be approved. These
requests can be made through the existing social channel in the OpenJS Slack.
For that reason and for communication purposes and collaboration opportunities,
ambassadors should be members of the
[OpenJS Slack](https://slack-invite.openjsf.org/).

## Messages and topics to promote

### How to add messages or topics to promote

Messages or topics that ambassadors are asked to promote are added to this
document in the [Current messages for promotion](#current-messages-for-promotion)
section through the standard PR process except that they should be open
for 7 days before landing and should include and at mention to the
nodejs/TSC for awareness. They should be removed through the same process
when no longer relevant.

### Current messages for promotion

#### Sample message (Leave this one at the top)

##### Goal

The goal is to raise awareness of XYZ in the JavaScript ecosystem.

##### Related Links

List of links with more information about the topic to provide background
or the information to be shared.

##### Project contacts

Add a list of GitHub handles for those within the project that
have volunteered to be contacted when necessary by ambassadors
to get more info about the message to be promoted.

#### Node.js is a great choice for a JavaScript runtime

##### Goal

Highlight the benefits of choosing Node.js as your backend JavaScript runtime. Focus on what is great
about Node.js without drawing comparisons to alternatives. We don't want to say negative things about
other options, only highlight what is great about Node.js as a choice.

Some of the things to highlight include:

* How widely it is used (you never get fired for choosing Node.js).
* The openness of the project. It is part of the OpenJS Foundation and it's governance is set up to avoid
  any one company from dominating the project. Decisions are made by the collaborators (of which there are quite
  a few) versus a small number of people.
* It has predictable and stable releases and has delivered on the release schedule since 2015.
* It was a well defined security release process and manages security releases well.
* As the defacto standard, it has the highest likelihood of being supported for a given package on npm.
* It is not dependent on any one company for its continued existence reducing risk of using it.
* The large number of platforms supported.
* Asynchronous non-blocking i/o architecture drives high transactional throughput, making it ideal for web workloads.
* Single threaded programming model enables very low resource consumption, making it ideal for containerised workloads.
* Highly vibrant ecosystem with enterprise support from many vendors.

##### Related Links

* <https://github.com/nodejs/release>
* <https://github.com/nodejs/node/blob/main/doc/contributing/security-release-process.md>
* <https://github.com/nodejs/TSC/blob/main/TSC-Charter.md>
* <https://github.com/mhdawson/presentations/blob/main/2024/NodeConfEU_2024-Node.js_whats_next.pdf>
  for slide  usage and topping recent surveys.

##### Project contacts

* @mhdawson

#### How things get done in the Node.js project

##### Goal

Help people understand that no people are paid to answer their issues or
implement their pull requests. Things get done based on what volunteers work on
and the best way to get something fixed/changed is to submit a Pull request.

Some of the things to highlight include:

* Nobody is paid specifically to answer issues, fix bugs or implement new features.
* No company owns/supports Node.js. Most contributions are from individuals
  as opposed to organizations. When an individual becomes a collaborator
  the access and privileges are granted to the individual, their employer does
  not gain any additional rights in the project.
* The governance of the project is specifically designed to prevent one or
  a small number of companies from dominating the project.
* Decisions are made by the active collaborators, there is no single person
  who makes a decision for the project on their own. This can slow down
  decision making but most often results in better outcomes.
* The project is open and receptive to contributions. If you need something PR
  in a fix or feature.
* Maintainers are people just like you, with many priorities and end goals. We
  all have the same goal of moving the Node.js project forward but at the same
  time we all have other responsibilities that affect how much time we have
  available to do so.
* People are volunteering their time to review your PRs and answer questions in
  the issues you open. Be mindfull of your asks for their time and acknowledge
  the gift of their time. Too many issues/PRs in a short period of time may
  overwhelm maintainers leading to less progress versus more, try to pace your
  issues and PRs so that you don't have too many open at the same time. The
  same goes for comments in discussions, try to avoid overwhelming a discussion
  with too many responses, even too much useful data can overwhelm a discussion
  leading to lower engagement.
* While volunteers work to do the right thing for the community, the project
  does not owe anybody anything and does not tolerate abusive or
  demanding language in issues, discussions or PRs. A respectful dialog will
  maximize the chances of the outcome you desire.
* If you depend on timely support or an SLA, contract with a company that provides
  paid support and will prioritize your issues.

##### Related Links

* <https://github.com/nodejs/TSC/blob/main/TSC-Charter.md#section-3-establishment-of-the-tsc>

##### Project contacts

* @mcollina
* @mhdawson
* @marco-ippolito

You can find their contact email in the [`README.md`](../../README.md#tsc-technical-steering-committee)

#### Node.js Type Stripping

##### Goal

The goal is to raise awareness of the Node.js TypeScript Type Stripping in the JavaScript ecosystem.
Some of the things to highlight include:

* The benefits and limitations of the current implementation.
* The `tsconfig.json` configuration options to use in combination for type checking.
* Updates on the implementation advancements.

##### Related Links

<!-- lint disable prohibited-strings remark-lint-->

* <https://github.com/nodejs/typescript>
* <https://nodejs.org/api/typescript.html>
* <https://nodejs.org/en/learn/typescript/run-natively>
* <https://satanacchio.hashnode.dev/everything-you-need-to-know-about-nodejs-type-stripping>
* <https://github.com/nodejs/amaro>

<!-- lint enable prohibited-strings remark-lint-->

##### Project contacts

* @marco-ippolito

#### Do I still need this dependency for my Node.js app?

##### Goal

Advancements over time in Node.js are improving the out of the box experience.
New versions are released all the time across Active LTS and Current development lines.
It's easy to miss something between the release notes and our busy work schedules.

Each of these on its own is respectable, but together they make a more cohesive narrative.
This also shows a [healthy ecosystem at work](https://brianmuenzenmeyer.com/posts/2024-do-i-need-this-node-dependency/#oss-pace-layers),
with projects learning from one another and their users.

"Recent" new or newish features, ordered by availability:

| Feature                                                                                               | Introduced                                             | Release Status                                                     |
| ----------------------------------------------------------------------------------------------------- | ------------------------------------------------------ | ------------------------------------------------------------------ |
| [testing source code](https://nodejs.org/api/test.html)                                               | [16.17.0](https://nodejs.org/en/blog/release/v16.17.0) | Stable as of 20.0.0                                                |
| [watching source code](https://nodejs.org/api/cli.html#--watch)                                       | [16.19.0](https://nodejs.org/en/blog/release/v16.19.0) | Stable as of 20.13.0                                               |
| [parsing arguments](https://nodejs.org/api/util.html#utilparseargsconfig)                             | [18.3.0](https://nodejs.org/en/blog/release/v18.3.0)   | Stable as of 20.0.0                                                |
| [reading environment](https://nodejs.org/api/cli.html#--env-fileconfig)                               | [20.6.0](https://nodejs.org/en/blog/release/v20.6.0)   | Active Development                                                 |
| [styling output](https://nodejs.org/docs/latest-v22.x/api/util.html#utilstyletextformat-text-options) | [20.12.0](https://nodejs.org/en/blog/release/v20.12.0) | Stable, as of [22.13.0](https://github.com/nodejs/node/pull/56329) |
| [run scripts](https://nodejs.org/docs/latest/api/cli.html#--run)                                      | [22.0.0](https://nodejs.org/en/blog/release/v22.0.0)   | Stable, as of 22.0.0                                               |
| [run TypeScript](https://nodejs.org/api/cli.html#--experimental-strip-types)                          | [22.6.0](https://nodejs.org/en/blog/release/v22.6.0)   | Active Development                                                 |

##### Related Links

<!-- lint disable prohibited-strings remark-lint-->

* <https://brianmuenzenmeyer.com/posts/2024-do-i-need-this-node-dependency/>
* <https://nodejs.org/api/test.html>
* <https://nodejs.org/api/cli.html#--watch>
* <https://nodejs.org/api/util.html#utilparseargsconfig>
* <https://nodejs.org/api/cli.html#--env-fileconfig>
* <https://nodejs.org/docs/latest-v22.x/api/util.html#utilstyletextformat-text-options>
* <https://nodejs.org/api/cli.html#--run>
* <https://nodejs.org/api/cli.html#--experimental-strip-types>

<!-- lint enable prohibited-strings remark-lint-->

##### Project contacts

* @bmuenzenmeyer
