/**
 * Definitions of functions to include in the driver. These are embedded in macros so that it is
 * possible to generate code based on them in various parts of the system.
 */

// Connect to the database.
PG_FUNCTION(PQconnectdb, PGconn *, const char *info)

// Close a connection.
PG_FUNCTION(PQfinish, void, PGconn *conn)

// Get the status of a connection.
PG_FUNCTION(PQstatus, ConnStatusType, const PGconn *conn)

// Set the notice receiver function.
PG_OPTIONAL_FUNCTION(PQsetNoticeReceiver, PQnoticeReceiver, PGconn *conn, PQnoticeReceiver, void *arg)

// Clear a result object.
PG_FUNCTION(PQclear, void, PGresult *result)

// Execute a statement.
PG_FUNCTION(PQexec, PGresult *, PGconn *conn, const char *statement);

// Prepare a statement.
PG_FUNCTION(PQprepare, PGresult *, PGconn *conn,
			const char *stmtName, const char *query,
			int nParams, const Oid *paramTypes)

// Close a prepared statement. Note, this was introduced in version 17, which is still quite recent.
PG_OPTIONAL_FUNCTION(PQclosePrepared, PGresult *, PGconn *conn, const char *name)

// Execute a prepared statement without waiting for results.
PG_FUNCTION(PQsendQueryPrepared, int, PGconn *conn, const char *stmt,
			int nParams, const char * const * paramValues,
			const int *paramLengths, const int *paramFormats,
			int resultFormat)

// Set single row mode.
PG_FUNCTION(PQsetSingleRowMode, int, PGconn *conn)

// Get next result.
PG_FUNCTION(PQgetResult, PGresult *, PGconn *conn)

// Check result status.
PG_FUNCTION(PQresultStatus, ExecStatusType, const PGresult *result)

// Get number of affected rows.
PG_FUNCTION(PQcmdTuples, char *, PGresult *result)

// Get status of a result.
PG_FUNCTION(PQcmdStatus, char *, PGresult *result)

// Get information about a prepared statement.
PG_FUNCTION(PQdescribePrepared, PGresult *, PGconn *conn, const char *name)

// Get number of parameters to a prepared statement.
PG_FUNCTION(PQnparams, int, const PGresult *result)

// Get the inferred type of a parameter of a prepared statement.
PG_FUNCTION(PQparamtype, Oid, const PGresult *, int param_number)

// Get number of tuples.
PG_FUNCTION(PQntuples, int, PGresult *result)

// Get number of columns.
PG_FUNCTION(PQnfields, int, PGresult *result)

// Get type of a column.
PG_FUNCTION(PQftype, Oid, PGresult *result, int column_number)

// Get a value.
PG_FUNCTION(PQgetvalue, char *, PGresult *result, int row_number, int column_number)

// Get the length of a value.
PG_FUNCTION(PQgetlength, int, PGresult *result, int row_number, int column_number)

// Check if an element is null.
PG_FUNCTION(PQgetisnull, int, PGresult *result, int row_number, int column_number)

// Get error message.
PG_FUNCTION(PQerrorMessage, char *, const PGconn *conn)
PG_FUNCTION(PQresultErrorMessage, char *, const PGresult *res)

// Cancellation, new interface:
PG_OPTIONAL_FUNCTION(PQcancelCreate, PGcancelConn *, PGconn *conn)
PG_OPTIONAL_FUNCTION(PQcancelFinish, void, PGcancelConn *conn)
PG_OPTIONAL_FUNCTION(PQcancelBlocking, int, PGcancelConn *conn)

// Cancellation, old interface (deprecated, but required for version 16):
PG_OPTIONAL_FUNCTION(PQgetCancel, PGcancel *, PGconn *conn)
PG_OPTIONAL_FUNCTION(PQfreeCancel, void, PGcancel *c)
PG_OPTIONAL_FUNCTION(PQcancel, int, PGcancel *c, char *errbuf, int errbufsize)

// Tell Emacs what is going on:
/* Local Variables:  */
/* mode: c           */
/* End:              */
